//
//  ZeroButtonCell.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 18.02.23.
//

import UIKit

class ZeroButtonCell : UICollectionViewCell {
    
    let zeroDigit = UILabel()
    
    override var isHighlighted: Bool {
        didSet {
            print("Highlighted Cell:", isHighlighted)
            
            UIView.animate(withDuration: 0.25) {
                self.backgroundColor = self.isHighlighted ? UIColor(white: 1, alpha: 0.7) : UIColor.clear
                
                self.zeroDigit.textColor = self.isHighlighted ? .white : .white
            }
            
            
        }
    }
    
    override init(frame: CGRect) {
        
        super.init(frame: frame)
        
        // cell's background color
        backgroundColor = UIColor.clear
        
        // digits size and numbers
        zeroDigit.text = "0"
        zeroDigit.font = UIDevice.current.screenType == .iPhones_5_5s_5c_SE ? .systemFont(ofSize: 24, weight: .light) : .systemFont(ofSize: 32, weight: .light) // UIFont
        // number text color
        zeroDigit.textColor = UIColor.white //UIColor.init(red: 58/255, green: 181/255, blue: 78/255, alpha: 1)
        
        zeroDigit.textAlignment = .center
        
        let stackView = UIStackView(arrangedSubviews: [zeroDigit])
        stackView.axis = .vertical
        
        addSubview(stackView)
        stackView.centerInSuperview()
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        layer.cornerRadius = frame.width / 2
    }
    
    required init?(coder aDecoder:NSCoder) {
        fatalError()
    }
}
